import Vue from 'vue';
import Vuex from 'vuex';
const packageConfig = require('./../../package.json');

Vue.use(Vuex);

const modules = {};
const files = require.context('./modules', false, /\.js$/);

files.keys().forEach(key => {
  modules[key.replace(/(\.\/|\.js)/g, '')] = files(key).default;
});

const store = new Vuex.Store({
  namespaced: true,

  modules,

  state: {
    platformInfo: {
      moduleId: '#',
      systemId: ''/* '00000000-0000-0015-0001-000000000001' */,
      name: 'Smart Web 平台',
      // name: '国土测绘院政务系统',
      disabled: true,
      version: packageConfig.version || ''
    },
    unreadMessage: 0,           // 未读消息
    userInfo: {
      userId: '',
      SysId: '',
      OrganName: '',
      RealName: ''
    },
    userIdentity: 'none',       // 用户身份，admin, none
    theme: {
      format: 'left-right',
      themeColor: 'deep'
    },
    currentNavigation: {            // 当前页面信息
      name: '首页',
      id: 'home',
      componentName: 'appHome'
    },
    navigationList: []
  },

  mutations: {
    setUserInfo(state, payload) {
      state.userInfo = payload;
    },
    setUserIdentity(state, payload) {
      state.userIdentity = payload;
    },
    setTheme(state, payload) {
      state.theme = payload;
    },
    setNavigation(state, payload) {
      state.currentNavigation = payload;
      let flag = true;
      state.navigationList.forEach(item => {
        if (item.name === payload.name) {
          flag = false;
        }
      });
      // 判断是否新标签页插入
      if (flag) state.navigationList.push(payload);
    },
    removeNavigation(state, name) {
      const len = state.navigationList.length;
      for (let i = len - 1; i >= 0; i--) {
        if (state.navigationList[i].id === name) {
          state.navigationList.splice(i, 1);
        }
      }
    },
    initNavigation(state) {
      state.currentNavigation = {
        name: '首页',
        id: 'home',
        componentName: 'appHome'
      };
      state.navigationList = [{
        name: '首页',
        id: 'home',
        componentName: 'appHome'
      }];
    },
    setCurrentNavigation(state, name) {
      for (const nav of state.navigationList) {
        if (nav.componentName === 'settingColumn') {
          nav.name = name;
        }
      }
    },
    setUnreadMessage(state, count) {
      state.unreadMessage = count;
    }
  },

  actions: {
    setUserInfo(context, payload) {
      context.commit('setUserInfo', payload);

      if (payload && payload.Qua === 99) {
        context.commit('setUserIdentity', 'admin');
      } else {
        context.commit('setUserIdentity', 'none');
      }
    },
    setTheme({ commit }, payload) {
      commit('setTheme', payload);
    },
    setNavigation(context, payload) {
      if (context.state.currentNavigation.id === payload.id) return;

      const len = context.state.navigationList.length;
      for (let i = 0; i < len; i++) {
        if (context.state.navigationList[i].id === payload.id && !payload.param) {  // 存在在List，并且没带有param
          payload = context.state.navigationList[i];
          break;
        } else if (context.state.navigationList[i].id === payload.id && payload.param) {  // 存在在List，并且带有param
          context.state.navigationList[i].param = payload.param;
          break;
        }
      }
      context.commit('setNavigation', payload);
    },
    removeNavigation(context, name) {
      context.commit('removeNavigation', name);
    },
    initNavigation(context) {
      context.commit('initNavigation');
    },
    setCurrentNavigation(context, name) {
      context.commit('setCurrentNavigation', name);
    },
    setUnreadMessage(context, count) {
      context.commit('setUnreadMessage', count);
    }
  }
});

export default store;
