import Vue from 'vue';
import store from '@/store';
import Utils from '@/utils';
import { getTheme, changeTheme } from '@/utils/global';
import MyWebSocket from '@/utils/webSocket';

const vm = new Vue();
let webSocket = null;
/**
 * 应用初始化的一个配置操作
 * 比如检查登录、获取皮肤配置，其他配置等
 */

// 加载用户主题
if (localStorage.getItem('themeValue')) {
  const val = JSON.parse(localStorage.getItem('themeValue'));
  changeTheme(val);
} else {
  const val = {format: 'left-right', themeColor: 'deep'};
  changeTheme(val);
}

// 监听用户改变
vm.$watch(function() {
  return store.state.userInfo;
}, function(val) {
  if (!webSocket) webSocket = new MyWebSocket(store.state.userInfo);
  if (!Utils.isEmptyData(val)) {
    // 获取皮肤
    getTheme();
    webSocket.init();
  } else {
    webSocket.closeWebSocketConnection();
    webSocket = null;
  }
});
