import store from '../store';
import router from '../router';
import Api from '../api';
import Utils from './index';
import $ from './expression';

// 获取URL参数
export const getQueryString = (name) => {
  const reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)');
  const r = window.location.search.substr(1).match(reg); // 查询？后面的参数，并匹配正则
  if (r != null) return unescape(r[2]);
  const param = getHashParameters();
  if (param[name]) return param[name];
  return null;
};

function getHashParameters() {
  const arr = (location.hash || '').replace(/^#\/[a-zA-Z0-9]*\?/, '').split('&');
  const params = {};
  for (let i = 0; i < arr.length; i++) {
    const data = arr[i].split('=');
    if (data.length === 2) {
      params[data[0]] = data[1];
    }
  }
  return params;
}

// 改变初始化加载提示文字
const appLoadingSub = document.getElementById('app-loading-subtitle');
if (appLoadingSub) appLoadingSub.innerHTML = '正在获取系统信息中...';
// 移除加载页
export function removeLoading() {
  const el = document.getElementById('app-loading');
  if (el) {
    el.className = 'app-loading app-loading-leave';
    setTimeout(() => { el.parentNode && el.parentNode.removeChild(el); }, 251);
  }
}
// 获取系统信息
export function getSystemInfo(sysCode) {
  sysCode = sysCode || getQueryString('sysCode');
  return new Promise((resolve, reject) => {
    Api.getSystemInfo(sysCode).then(res => {
      removeLoading();

      if (res.status === 0) {
        store.state.platformInfo.systemId = res.data.systemId;
        store.state.platformInfo.name = res.data.sysMainTitle;

        resolve();
      } else {
        reject(res);
      }
    }).catch(err => {
      removeLoading();
      // 获取系统信息错误
      router.replace({
        name: 'Unfound'
      });
      reject(err);
    });
  });
}

/**
 * 获取用户信息
 */
export const getUser = $.system.getUser;
/**
 * 获取用户名
 */
export const getUserName = $.system.getUserName;

/**
 * 全局打开新标签页方法
 * 利用的是store, id作为唯一性检查，没有id就会自动生成id
 * @param {Object} data 组件的对象，比如 {id:'', name:'组织构架管理', componentName:'frameworkManage'}
 * @param {Any} param 绑定到数据里的param
 */
export const openTab = $.menu.openTab;

/**
 * 关闭/移除tab
 * @param {String} id tab标签的唯一标识
 */
export const removeTab = $.menu.removeTab;

/**
 * 刷新tab页
 * @param {String} id tab标签的唯一标识
 */
export const refreshTab = $.menu.refreshTab;

/**
 * 公共提示方法，一般用于组件内保存提交时提示
 * @param {object} options 和element-ui Notification组件属性一样
 */
export const notification = $.system.notification;

/**
 * 改变皮肤的方法
 * 为body添加is-class
 * @param {Object} theme
 */
export const changeTheme = (theme) => {
  document.body.className = theme.format + ' is-' + theme.themeColor;
  store.dispatch('setTheme', theme);
  localStorage.setItem('themeValue', JSON.stringify(theme));
};

/**
 * 获取个人界面皮肤配置
 */
export const getTheme = () => {
  Api.getUserConfigTheme().then(res => {
    if (res.status === 0) {
      const data = res.data;
      if (!Utils.isEmptyData(data)) {
        changeTheme(data);
      }
    }
  });
};

/**
 * 日期转成方法，注册到原型链上
 * @param {Stirng} fmt yyyy-MM-dd hh:mm:ss
 */
/* eslint no-extend-native: "off" */
Date.prototype.format = function(fmt) {
  const o = {
    'M+': this.getMonth() + 1, // 月份
    'd+': this.getDate(), // 日
    'h+': this.getHours(), // 小时
    'm+': this.getMinutes(), // 分
    's+': this.getSeconds(), // 秒
    'q+': Math.floor((this.getMonth() + 3) / 3), // 季度
    'S': this.getMilliseconds() // 毫秒
  };
  if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + '').substr(4 - RegExp.$1.length));
  for (const k in o) {
    if (new RegExp('(' + k + ')').test(fmt)) {
      fmt = fmt.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : (('00' + o[k]).substr(('' + o[k]).length)));
    }
  }
  return fmt;
};
