/**
 *  单独消息模块
 */
import { Notification } from 'element-ui';
import { baseUrl } from '@config/http.config';
import { openTab } from '@/utils/global';
import store from '@/store';
import Vue from 'vue';
const vm = new Vue();

function webSocket(userInfo) {
  this.instantce = null;
  this.userInfo = userInfo;
  this.$store = store;
  this.messageType = [{
    id: 'doingWork',
    name: '在办工作',
    status: [100, 101, 102, 103, 104, 105, 106, 109, 113, 112]
  },
  {
    id: 'returnBox',
    name: '退件箱',
    status: [108]
  },
  {
    id: 'suspendWork',
    name: '已挂工作',
    status: [110, 111]
  },
  {
    id: 'finishedWork',
    name: '办结工作',
    status: [107]
  }]; // 消息类型
}

webSocket.prototype = {
  /**
   * 初始化webSocket
   */
  init() {
    if (window.WebSocket && this.userInfo && this.userInfo.userId) {
      const that = this;
      this.instantce = new WebSocket(`ws:${baseUrl}/MessageWebsocket?userId=${this.userInfo.userId}`);
      this.instantce.onopen = function(event) {
      };
      this.instantce.onclose = function(event) {
      };
      this.instantce.onmessage = function(event) {
        if (event.data) that.handleReceiveMessage(event.data);
      };
      this.instantce.onerror = function(event) {
      };
    }
  },
  /**
   * 接受消息后的处理
   */
  handleReceiveMessage(data) {
    data = JSON.parse(data);
    this.$store.dispatch('setUnreadMessage', data.count);
    if (parseInt(data.count, 10) === 0) return false;
    const type = data.content ? this.handleMessageType(data.content.businessType) : 9999;
    const h = vm.$createElement;
    Notification({
      title: data.content ? data.content.title : this.convertTypeToObjectInfo(type).name,
      position: 'bottom-right',
      type: 'info',
      dangerouslyUseHTMLString: true,
      duration: 5000,
      message: h('div', {
        style: {
          display: 'flex',
          alignItems: 'center'
        }
      }, [
        h('span', null
          , data.content ? data.content.content : '您有新的处理任务，请及时处理!'),
        h('el-button', {
          style: {
            marginLeft: '5px'
          },
          attrs: {
            size: 'small',
            type: 'text'
          },
          on: {
            click: () => { this.handleLinkToTargetTab(type);}
          }
        }, '查看')
      ])
    });
  },
  /**
   *  跳转链接
   */
  handleLinkToTargetTab(type) {
    const that = this;
    openTab({
      id: that.convertTypeToObjectInfo(type).id,
      name: that.convertTypeToObjectInfo(type).name,
      componentName: that.convertTypeToObjectInfo(type).id
    });
  },
  /**
   * 转换成路由消息数据
   */
  convertTypeToObjectInfo(type) {
    return this.messageType[type] || { id: 'appMessage', name: '我的消息'};
  },
  /**
   * 处理消息类型
   */
  handleMessageType(type) {
    type = parseInt(type, 10) || 9999;
    let flag = false;
    // 找到对应的路由消息下标
    for (let i = 0; i < this.messageType.length; i++) {
      if (this.messageType[i].status.indexOf(type) >= 0) {
        type = i;
        flag = true;
      }
      if (flag) break;
    }
    return type;
  },

  /**
   *  关闭webSocket
   */
  closeWebSocketConnection() {
    window.WebSocket && this.instantce && this.instantce.close();
    this.instantce = null;
  }
};

export default webSocket;
