const webpack = require('webpack');
const path = require('path');
function resolve(dir) {
  return path.join(__dirname, dir);
}

const pages = {
  app: {
    // page 的入口
    entry: 'src/main.js',
    // 模板来源
    template: 'public/index.html',
    // 在 dist/index.html 的输出
    filename: 'index.html',
    // 在这个页面中包含的块，默认情况下会包含
    // 提取出来的通用 chunk 和 vendor chunk。
    chunks: ['chunk-vendors', 'chunk-commons', 'element-ui', 'app']
  },
  form: {
    entry: 'form/main.js',
    template: 'form/form.html',
    filename: 'form.html',
    chunks: ['chunk-vendors', 'chunk-commons', 'element-ui', 'smart-form', 'form']
  },
  charts: {
    entry: 'Apps/charts/main.js',
    template: 'Apps/charts/charts.html',
    filename: 'charts.html',
    chunks: ['chunk-vendors', 'element-ui', 'smart-charts', 'charts']
  }
};

module.exports = {
  publicPath: './',
  runtimeCompiler: true,
  devServer: {
    host: '0.0.0.0',
    port: '8022'
  },
  productionSourceMap: false,
  pages: pages,
  configureWebpack: config => {
    if (process.env.NODE_ENV === 'production') {
      const configs = {};
      configs.optimization = {
        splitChunks: {
          chunks: 'all',
          cacheGroups: {
            libs: {
              name: 'chunk-vendors',
              test: /[\\/]node_modules[\\/]/,
              priority: 10,
              chunks: 'initial' // 只打包初始时依赖的第三方
            },
            elementUI: {
              name: 'element-ui', // 单独将 elementUI 拆包
              priority: 20, // 权重要大于 libs 和 app 不然会被打包进 libs 或者 app
              test: /[\\/]node_modules[\\/]element-ui[\\/]/
            },
            smartForm: {
              name: 'smart-form', // 单独将拆包
              priority: 21, // 权重要大于 libs 和 app 不然会被打包进 libs 或者 app
              test: /[\\/]node_modules[\\/]smart-form[\\/]/
            },
            smartCharts: {
              name: 'smart-charts', // 单独将拆包
              priority: 21, // 权重要大于 libs 和 app 不然会被打包进 libs 或者 app
              test: /[\\/]node_modules[\\/]smart-charts[\\/]/
            }
            /*
            commons: {
              name: 'chunk-comomns',
              test: resolve('src/components'), // 可自定义拓展你的规则
              minChunks: 2, // 最小共用次数
              priority: 5,
              reuseExistingChunk: true
            } */
          }
        }
      };

      return configs;
    }
  },
  chainWebpack: config => {
    config.resolve.alias
      .set('@', resolve('src'))
      .set('@form', resolve('form'))
      .set('@config', resolve('config'));

    const arr = ['app', 'form'];
    // TODO: Remove this workaround once https://github.com/vuejs/vue-cli/issues/2463 is fixed
    // Remove preload plugins for multi-page build to prevent infinite recursion
    arr.forEach(page => {
      config.plugins.delete(`preload-${page}`);
      config.plugins.delete(`prefetch-${page}`);
    });

    config.plugin('ignore')
      .use(new webpack.IgnorePlugin(/^\.\/locale$/, /moment$/));

  },
  // IE兼容
  transpileDependencies: ['element-ui/src', 'element-ui/packages', 'smart-web']
};
