/* eslint-disable import/no-extraneous-dependencies */
import path from 'path';
import { defineConfig } from 'vite';
import vue from '@vitejs/plugin-vue';
import PkgConfig from 'vite-plugin-package-config';
import { vitePluginCopy } from '@smart/vite-plugin-copy';

const appRoot = '.';

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    PkgConfig(),
    vue(),
    vitePluginCopy([
      {
        src: 'node_modules/@smart/cesium/Build/Cesium/*',
        target: path.resolve(appRoot, 'public/assets/Cesium'),
      },
      {
        src: 'node_modules/smart3d/dist/smart3d/*',
        target: path.resolve(appRoot, 'public/assets/smart3d'),
      },
      // {
      //   src: '../node_modules/@turf/turf/turf.min.js',
      //   target: path.resolve(appRoot, 'public/assets/turf'),
      // },
    ]),
  ],
});
