const path = require('path')
const webpack = require('webpack')

function addStyleResource(rule) {
  rule.use('style-resource')
    .loader('style-resources-loader')
    .options({
      patterns: [
        path.resolve(__dirname, './src/styles/var.scss')
      ]
    })
}

module.exports = {
  publicPath: './',
  assetsDir: '',
  runtimeCompiler: true,
  lintOnSave: 'error',
  devServer: {
    host: '0.0.0.0',
    port: '8080'
  },
  productionSourceMap: false,
  css: {
    // extract: true
  },
  configureWebpack: config => {
    if (process.env.NODE_ENV === 'production') {
      let configs = {}
      configs.optimization = {
        splitChunks: {
          chunks: 'all',
          cacheGroups: {
            libs: {
              name: 'chunk-libs',
              test: /[\\/]node_modules[\\/]/,
              priority: 10,
              chunks: 'initial' // 只打包初始时依赖的第三方
            },
            elementUI: {
              name: 'element-ui', // 单独将 elementUI 拆包
              priority: 20, // 权重要大于 libs 和 app 不然会被打包进 libs 或者 app
              test: /[\\/]node_modules[\\/]element-ui[\\/]/
            }/* ,
            commons: {
              name: 'chunk-comomns',
              test: resolve('src/components'), // 可自定义拓展你的规则
              minChunks: 2, // 最小共用次数
              priority: 5,
              reuseExistingChunk: true
            } */
          }
        }
      }

      if (process.env.npm_config_report) {
        const BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin
        configs.plugins = [
          new BundleAnalyzerPlugin()
        ]
      }

      return configs
    }
  },
  chainWebpack: config => {
    // 修复HMR
    // config.resolve.symlinks(true)

    config.plugin('ignore')
      .use(new webpack.IgnorePlugin(/^\.\/locale$/, /moment$/))

    const types = ['vue-modules', 'vue', 'normal-modules', 'normal']
    types.forEach(type => addStyleResource(config.module.rule('stylus').oneOf(type)))
  }
}
