﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Lottery
{
    /// <summary>
    /// 表示奖项信息
    /// </summary>
    class Lottery
    {
        public int Level { get; private set; }

        public string Name { get; private set; }

        public string Prize { get; private set; }

        public int Count { get; private set; }

        public static IReadOnlyList<Lottery> GetLotteries()
        {
            string filePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "l.txt");
            return File.Exists(filePath) ? File.ReadLines(filePath).Where(p => !string.IsNullOrEmpty(p)).Select(p =>
            {
                var items = p.Split(';');
                return new Lottery { Level = int.Parse(items[0]), Name = items[1], Prize = items[2], Count = int.Parse(items[3]) };
            }).ToList() : new List<Lottery>()
            {
                new Lottery{ Count = 1, Level = 1, Name = "一等奖", Prize = "键盘" },
                new Lottery{ Count = 3, Level = 2, Name = "二等奖" , Prize = "按摩仪"},
                new Lottery{ Count = 8, Level = 3, Name = "三等奖" , Prize = "坚果礼盒"},
                new Lottery{ Count = 55, Level = 4, Name = "阳光普照奖", Prize = "身体乳、大宝SOD密、旅行套装、靠枕、鼠标垫" },
                new Lottery{ Count = 100, Level = 5, Name = "未中奖" },
             };
        }
    }
}
