﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace Lottery
{
    static class LotteryResult
    {
        /// <summary>
        /// 保存结果
        /// </summary>
        /// <param name="persons">抽奖人员</param>
        /// <param name="lotteries">奖项信息</param>
        public static void SaveResult(IReadOnlyList<Person> persons, IReadOnlyList<Lottery> lotteries)
        {
            Console.Clear();
            Console.WriteLine("抽奖结果" + Environment.NewLine);
            string saveFile = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Result.txt");
            if (File.Exists(saveFile))
            {
                File.Delete(saveFile);
            }
            var stream = new FileStream(saveFile, FileMode.Create);
            for (int i = 0; i < lotteries.Count; i++)
            {
                Console.ForegroundColor = ConsoleColor.Yellow;
                var lottery = $"{lotteries[i].Name}：{lotteries[i].Prize}";
                Console.WriteLine(lottery);
                var text = Encoding.UTF8.GetBytes(lottery + Environment.NewLine);
                stream.Write(text, 0, text.Length);
                Console.ForegroundColor = ConsoleColor.White;
                persons.OrderByDescending(p => p.NewGrade)
                       .Skip(Enumerable.Range(0, i).Sum(p => lotteries[p].Count))
                       .Take(lotteries[i].Count)
                       .ToList()
                       .ForEach(p =>
                       {
                           var content = p.Name + "\t";
                           Console.Write(content);
                           text = Encoding.UTF8.GetBytes(content);
                           stream.Write(text, 0, text.Length);
                       });
                Console.WriteLine(Environment.NewLine);
                text = Encoding.UTF8.GetBytes(Environment.NewLine);
                stream.Write(text, 0, text.Length);
            }
            stream.Flush();
            stream.Dispose();
            Console.WriteLine("抽奖结果已保存在程序运行目录下的Result.txt文件");
        }
    }
}
