﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace Lottery
{
    static class Screen
    {
        static List<Person> old = new List<Person>();
        public static void ShowTitle(string title)
        {
            Console.ForegroundColor = ConsoleColor.Cyan;
            Enumerable.Range(0, Console.WindowWidth - 3).ToList().ForEach(p => Console.Write("$"));
            Console.Write(Environment.NewLine);
            Console.SetCursorPosition(Console.WindowWidth / 2, 1);
            title.ToList().ForEach(p => Console.Write(p));
            Console.Write(Environment.NewLine);
            Console.SetCursorPosition(0, 2);
            Enumerable.Range(0, Console.WindowWidth - 3).ToList().ForEach(p => Console.Write("$"));
            Console.Write(Environment.NewLine);
        }

        public static void Show(int i, IReadOnlyList<Person> persons, IReadOnlyList<Lottery> lotteries)
        {
            var temp = persons.OrderByDescending(p => p.NewGrade).ToList();
            if (i == 1)
            {
                old.AddRange(temp);
            }
            else if (i > 1)
            {
                Console.WriteLine();
                var n = temp.Take(lotteries.Where(p => p.Level <= 3).Sum(p => p.Count)).Max(p => old.LastIndexOf(p));
                Console.WriteLine($"逆袭大神：{old[n].Name}");
                n = old.Take(lotteries.Where(p => p.Level <= 3).Sum(p => p.Count))
                       .Max(p => temp.LastIndexOf(p));
                Console.WriteLine();
                Console.WriteLine($"翻车小弟：{persons[n].Name}");
                old.Clear();
                old.AddRange(temp);
            }
        }

        public static void ShowGradeList(IReadOnlyList<Person> person, int highlight)
        {
            Console.Write(Environment.NewLine);

            int colCount = 3;
            var titles = new List<string> { "排名", "人名", "金币" };
            var people = person.OrderByDescending(p => p.NewGrade).ToList();
            Console.ForegroundColor = ConsoleColor.Yellow;

            //将结果分为多列输出，每列间隔
            int colGap = (int)(Console.WindowWidth * 0.05);
            //每列宽度
            int colWidth = (Console.WindowWidth - colGap * (colCount-1)) / colCount;
            //每列中分为多个表头，每个表头的宽度
            int titleWidth = colWidth / titles.Count();

            //添加表头
            for (int colIndex = 0; colIndex < colCount; colIndex++)
            {
                for (int i = 0; i < titles.Count; i++)
                {
                    Console.SetCursorPosition((colWidth + colGap) * colIndex + titleWidth * i, 4);
                    Console.Write(titles[i]);
                }
            }
            Console.Write(Environment.NewLine);

            //按照从上到下、从左到右的顺序分多列输出结果
            int rowCount = (int)Math.Ceiling((double)person.Count() / colCount);
            for (int i = 0; i < people.Count; i++)
            {
                int rowIndex = i % rowCount;
                int colIndex = i / rowCount;
                int index = i + 1;

                Console.ForegroundColor = index <= highlight ? ConsoleColor.Yellow : ConsoleColor.White;
                Console.SetCursorPosition((colWidth + colGap) * colIndex + 0, rowIndex + 5);
                Console.Write(index);
                Console.SetCursorPosition((colWidth + colGap) * colIndex + titleWidth, rowIndex + 5);
                Console.Write(people[i].Name);
                Console.SetCursorPosition((colWidth + colGap) * colIndex + titleWidth * 2, rowIndex + 5);
                Console.Write(people[i].NewGrade);

                if (colIndex == colCount - 1 || index == people.Count)
                {
                    //每行的最后一列
                    Console.Write(Environment.NewLine);
                }
            }
        }

        [DllImport("User32.dll", EntryPoint = "FindWindow")]
        private static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        [DllImport("user32.dll", EntryPoint = "FindWindowEx")]
        private static extern IntPtr FindWindowEx(IntPtr hwndParent, IntPtr hwndChildAfter, string lpszClass, string lpszWindow);

        [DllImport("User32.dll", EntryPoint = "SendMessage")]
        private static extern int SendMessage(IntPtr hWnd, int Msg, IntPtr wParam, string lParam);

        [DllImport("User32.dll", EntryPoint = "ShowWindow")]
        private static extern bool ShowWindow(IntPtr hWnd, int type);

        public static void Init()
        {
            Console.Title = "1024抽奖程序";
            IntPtr ParenthWnd = new IntPtr(0);
            IntPtr et = new IntPtr(0);
            ParenthWnd = FindWindow(null, "1024抽奖程序");
            //最大化
            ShowWindow(ParenthWnd, 3);
            Console.SetWindowSize(Console.LargestWindowWidth, Console.LargestWindowHeight);
            Console.BufferWidth = Console.LargestWindowWidth;
            Console.BufferHeight = Console.LargestWindowHeight * 2;
            Console.WindowLeft = Console.WindowTop = 0;
            Enumerable.Range(0, Console.LargestWindowWidth).ToList().ForEach(p => Enumerable.Range(0, Console.LargestWindowHeight).ToList().ForEach(d => Console.Write("")));
        }
    }
}
